using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Common;
using SPECIMENTESTTHRESHOLD = gov.va.med.vbecs.Common.VbecsTables.SpecimenTestThreshold;
using COMPONENTCLASS = gov.va.med.vbecs.Common.VbecsTables.ComponentClassParameter;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

	public class FrmConfigureComponents : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private DataTable _ComponentClasses;		
		private DataTable _LabTests;		
		private bool _isLoading = false;
		private BOL.LabTest _LabTest;
		private DataRow _selectedComponentClass;
		private BOL.BloodComponentClass _ComponentClass;
		private bool _removeItem;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpComponentClass;
		private System.Windows.Forms.Label lblMinutes;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updMaxTransfusionTime;
		private System.Windows.Forms.Label lblMaxTransfusionTime;
		private System.Windows.Forms.GroupBox grpRequestIndicators;
		private System.Windows.Forms.TextBox txtThresholdResult;
		private System.Windows.Forms.Label lblThresholdResult;
		private System.Windows.Forms.Label lblSpecimenType;
		private System.Windows.Forms.TextBox txtLabTestName;
		private System.Windows.Forms.Label lblLabTestName;
		private System.Windows.Forms.GroupBox grpConfigure;
		private System.Windows.Forms.CheckBox cbSpecimen;
		private System.Windows.Forms.ListView lvComponentClass;
		private System.Windows.Forms.Button btnClear;
		private System.ComponentModel.IContainer components = null;


		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUpdate;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.ColumnHeader colLabTestName;
		private System.Windows.Forms.ColumnHeader colSpecimenType;
		private System.Windows.Forms.ColumnHeader colThresholdResult;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.ListView lvInappropriateRequests;
		private System.Windows.Forms.Label lblSpecimen;
		private System.Windows.Forms.TextBox txtSpecimenType;
		private System.Windows.Forms.Button btnSelectLabTest;
		
		private System.Windows.Forms.CheckBox cbShowInactive;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.Panel pnlConfigWarning;
		private System.Windows.Forms.Panel pnlRequestIndicators;
		private System.Windows.Forms.Panel pnlRight;
		private System.Windows.Forms.PictureBox picConfigWarning;
		private System.Windows.Forms.Label lblConfigWarning;
		private System.Windows.Forms.ColumnHeader colIEN;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Constructor. Checks user privileges and adds any existing blood component class
		/// parameters neccessary for the division.
		///</summary>
		public FrmConfigureComponents()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC050ConfigureComponentClasses;

			InitializeComponent();

			this._isLoading = true;
			//
			_ComponentClass = new BOL.BloodComponentClass();
			//_ComponentClass.IsDirtyChanged += new System.EventHandler(CheckValid);
			//_ComponentClass.Valid += new System.EventHandler(CheckValid);
			//_ComponentClass.Invalid += new System.EventHandler(CheckValid);
			//
			_ComponentClasses = _ComponentClass.GetComponentClasses();
			_ComponentClasses.AcceptChanges();
			LoadComponentClasses();
			//
			GetLabTests();
			_LabTests.AcceptChanges();
			//
			_ComponentClasses.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);
			_LabTests.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);
			//
			Clear();
			//
			SetComponentProperties();
			//
			this.btnOK.EnabledButton = false;
			this.IsDirty = false;
			//


			//Locking Check --- SpecimenTestThresholdGuid, COmoponentClassParameterGuid
			foreach (System.Data.DataRow drCC in this._ComponentClasses.Rows)
			{
				this.LockController.RecordGuids.Add((Guid)drCC[COMPONENTCLASS.ComponentClassParameterGuid]);
			}
			foreach (System.Data.DataRow drSTT in this._LabTests.Rows)
			{
                this.LockController.RecordGuids.Add((Guid)drSTT[SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid]);
			}


			//Try locking them all
			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmConfigureComponents));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.updMaxTransfusionTime = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.txtThresholdResult = new System.Windows.Forms.TextBox();
            this.txtLabTestName = new System.Windows.Forms.TextBox();
            this.cbSpecimen = new System.Windows.Forms.CheckBox();
            this.lvComponentClass = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.imageList1 = new System.Windows.Forms.ImageList(this.components);
            this.btnClear = new System.Windows.Forms.Button();
            this.btnUpdate = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpComponentClass = new System.Windows.Forms.GroupBox();
            this.lblMinutes = new System.Windows.Forms.Label();
            this.lblMaxTransfusionTime = new System.Windows.Forms.Label();
            this.grpRequestIndicators = new System.Windows.Forms.GroupBox();
            this.cbShowInactive = new System.Windows.Forms.CheckBox();
            this.txtSpecimenType = new System.Windows.Forms.TextBox();
            this.lvInappropriateRequests = new System.Windows.Forms.ListView();
            this.colActive = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLabTestName = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colIEN = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSpecimenType = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colThresholdResult = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.btnSelectLabTest = new System.Windows.Forms.Button();
            this.lblThresholdResult = new System.Windows.Forms.Label();
            this.lblSpecimenType = new System.Windows.Forms.Label();
            this.lblLabTestName = new System.Windows.Forms.Label();
            this.grpConfigure = new System.Windows.Forms.GroupBox();
            this.pnlRight = new System.Windows.Forms.Panel();
            this.pnlRequestIndicators = new System.Windows.Forms.Panel();
            this.pnlConfigWarning = new System.Windows.Forms.Panel();
            this.picConfigWarning = new System.Windows.Forms.PictureBox();
            this.lblConfigWarning = new System.Windows.Forms.Label();
            this.lblSpecimen = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.updMaxTransfusionTime)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpComponentClass.SuspendLayout();
            this.grpRequestIndicators.SuspendLayout();
            this.grpConfigure.SuspendLayout();
            this.pnlRight.SuspendLayout();
            this.pnlRequestIndicators.SuspendLayout();
            this.pnlConfigWarning.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picConfigWarning)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(612, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Configure Component Classes";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 419);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(448, 401);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(528, 401);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // updMaxTransfusionTime
            // 
            this.updMaxTransfusionTime.AccessibleDescription = "Maximum Transfusion Time minutes";
            this.updMaxTransfusionTime.AccessibleName = "Maximum Transfusion Time minutes";
            this.updMaxTransfusionTime.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.updMaxTransfusionTime.Location = new System.Drawing.Point(260, 4);
            this.updMaxTransfusionTime.Maximum = new decimal(new int[] {
            999,
            0,
            0,
            0});
            this.updMaxTransfusionTime.Minimum = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.updMaxTransfusionTime.Name = "updMaxTransfusionTime";
            this.updMaxTransfusionTime.Size = new System.Drawing.Size(52, 20);
            this.updMaxTransfusionTime.TabIndex = 1;
            this.updMaxTransfusionTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.updMaxTransfusionTime.Value = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.updMaxTransfusionTime.TextChanged += new System.EventHandler(this.updMaxTransfusionTime_ValueChanged);
            this.updMaxTransfusionTime.ValueChanged += new System.EventHandler(this.updMaxTransfusionTime_ValueChanged);
            this.updMaxTransfusionTime.Leave += new System.EventHandler(this.updMaxTransfusionTime_Leave);
            // 
            // txtThresholdResult
            // 
            this.txtThresholdResult.AccessibleDescription = "Threshold Result";
            this.txtThresholdResult.AccessibleName = "Threshold Result";
            this.txtThresholdResult.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtThresholdResult.Location = new System.Drawing.Point(128, 68);
            this.txtThresholdResult.MaxLength = 15;
            this.txtThresholdResult.Name = "txtThresholdResult";
            this.txtThresholdResult.Size = new System.Drawing.Size(216, 20);
            this.txtThresholdResult.TabIndex = 6;
            this.txtThresholdResult.TextChanged += new System.EventHandler(this.txtThresholdResult_Leave);
            this.txtThresholdResult.Leave += new System.EventHandler(this.txtThresholdResult_Leave);
            // 
            // txtLabTestName
            // 
            this.txtLabTestName.AccessibleDescription = "Laboratory Test Name";
            this.txtLabTestName.AccessibleName = "Laboratory Test Name";
            this.txtLabTestName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtLabTestName.Location = new System.Drawing.Point(128, 20);
            this.txtLabTestName.Name = "txtLabTestName";
            this.txtLabTestName.ReadOnly = true;
            this.txtLabTestName.Size = new System.Drawing.Size(216, 20);
            this.txtLabTestName.TabIndex = 1;
            // 
            // cbSpecimen
            // 
            this.cbSpecimen.AccessibleDescription = "Require Current Specimen ABO/Rh Results";
            this.cbSpecimen.AccessibleName = "Require Current Specimen ABO/Rh Results";
            this.cbSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbSpecimen.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbSpecimen.Location = new System.Drawing.Point(16, 16);
            this.cbSpecimen.Name = "cbSpecimen";
            this.cbSpecimen.Size = new System.Drawing.Size(264, 20);
            this.cbSpecimen.TabIndex = 1;
            this.cbSpecimen.Text = "&Require current specimen ABO/Rh results?";
            this.cbSpecimen.CheckedChanged += new System.EventHandler(this.cbSpecimen_CheckedChanged);
            // 
            // lvComponentClass
            // 
            this.lvComponentClass.AccessibleDescription = "Select Component Class";
            this.lvComponentClass.AccessibleName = "Select Component Class";
            this.lvComponentClass.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvComponentClass.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2});
            this.lvComponentClass.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvComponentClass.HideSelection = false;
            this.errError.SetIconAlignment(this.lvComponentClass, System.Windows.Forms.ErrorIconAlignment.TopLeft);
            this.lvComponentClass.LabelWrap = false;
            this.lvComponentClass.LargeImageList = this.imageList1;
            this.lvComponentClass.Location = new System.Drawing.Point(8, 16);
            this.lvComponentClass.MultiSelect = false;
            this.lvComponentClass.Name = "lvComponentClass";
            this.lvComponentClass.Size = new System.Drawing.Size(136, 333);
            this.lvComponentClass.TabIndex = 0;
            this.lvComponentClass.UseCompatibleStateImageBehavior = false;
            this.lvComponentClass.View = System.Windows.Forms.View.SmallIcon;
            this.lvComponentClass.SelectedIndexChanged += new System.EventHandler(this.lvComponentClass_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Width = 120;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Width = 0;
            // 
            // imageList1
            // 
            this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
            this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
            this.imageList1.Images.SetKeyName(0, "");
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClear.Location = new System.Drawing.Point(292, 92);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 8;
            this.btnClear.Text = "C&lear";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // btnUpdate
            // 
            this.btnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnUpdate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnUpdate.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdate.Image")));
            this.btnUpdate.Location = new System.Drawing.Point(212, 92);
            this.btnUpdate.Name = "btnUpdate";
            this.btnUpdate.Size = new System.Drawing.Size(75, 23);
            this.btnUpdate.TabIndex = 7;
            this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
            this.btnUpdate.MouseHover += new System.EventHandler(this.btnUpdate_MouseHover);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 361);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpComponentClass
            // 
            this.grpComponentClass.AccessibleDescription = "Select Component Class";
            this.grpComponentClass.AccessibleName = "Select Component Class";
            this.grpComponentClass.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpComponentClass.Controls.Add(this.lvComponentClass);
            this.grpComponentClass.Location = new System.Drawing.Point(60, 32);
            this.grpComponentClass.Name = "grpComponentClass";
            this.grpComponentClass.Size = new System.Drawing.Size(152, 361);
            this.grpComponentClass.TabIndex = 0;
            this.grpComponentClass.TabStop = false;
            this.grpComponentClass.Text = "Select Component Class";
            // 
            // lblMinutes
            // 
            this.lblMinutes.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.lblMinutes.Location = new System.Drawing.Point(312, 4);
            this.lblMinutes.Name = "lblMinutes";
            this.lblMinutes.Size = new System.Drawing.Size(44, 20);
            this.lblMinutes.TabIndex = 2;
            this.lblMinutes.Text = "Minutes";
            this.lblMinutes.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblMaxTransfusionTime
            // 
            this.lblMaxTransfusionTime.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblMaxTransfusionTime.Location = new System.Drawing.Point(8, 4);
            this.lblMaxTransfusionTime.Name = "lblMaxTransfusionTime";
            this.lblMaxTransfusionTime.Size = new System.Drawing.Size(248, 20);
            this.lblMaxTransfusionTime.TabIndex = 0;
            this.lblMaxTransfusionTime.Text = "Maximum Transfusion Time*";
            this.lblMaxTransfusionTime.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpRequestIndicators
            // 
            this.grpRequestIndicators.AccessibleDescription = "In appropriate Request Indicators";
            this.grpRequestIndicators.AccessibleName = "In appropriate Request Indicators";
            this.grpRequestIndicators.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpRequestIndicators.Controls.Add(this.cbShowInactive);
            this.grpRequestIndicators.Controls.Add(this.txtSpecimenType);
            this.grpRequestIndicators.Controls.Add(this.lvInappropriateRequests);
            this.grpRequestIndicators.Controls.Add(this.btnSelectLabTest);
            this.grpRequestIndicators.Controls.Add(this.btnUpdate);
            this.grpRequestIndicators.Controls.Add(this.btnClear);
            this.grpRequestIndicators.Controls.Add(this.txtThresholdResult);
            this.grpRequestIndicators.Controls.Add(this.lblThresholdResult);
            this.grpRequestIndicators.Controls.Add(this.lblSpecimenType);
            this.grpRequestIndicators.Controls.Add(this.txtLabTestName);
            this.grpRequestIndicators.Controls.Add(this.lblLabTestName);
            this.grpRequestIndicators.Location = new System.Drawing.Point(0, 28);
            this.grpRequestIndicators.Name = "grpRequestIndicators";
            this.grpRequestIndicators.Size = new System.Drawing.Size(376, 252);
            this.grpRequestIndicators.TabIndex = 3;
            this.grpRequestIndicators.TabStop = false;
            this.grpRequestIndicators.Text = "Inappropriate Request Indicators";
            // 
            // cbShowInactive
            // 
            this.cbShowInactive.AccessibleDescription = "Show Inactive Inappropriate Request Indicators";
            this.cbShowInactive.AccessibleName = "Show Inactive Inappropriate Request Indicators";
            this.cbShowInactive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactive.Location = new System.Drawing.Point(8, 232);
            this.cbShowInactive.Name = "cbShowInactive";
            this.cbShowInactive.Size = new System.Drawing.Size(360, 16);
            this.cbShowInactive.TabIndex = 10;
            this.cbShowInactive.Text = "&Show Inactive Inappropriate Request Indicators";
            this.cbShowInactive.CheckedChanged += new System.EventHandler(this.cbShowInactive_CheckedChanged);
            // 
            // txtSpecimenType
            // 
            this.txtSpecimenType.AccessibleDescription = "Specimen Type";
            this.txtSpecimenType.AccessibleName = "Specimen Type";
            this.txtSpecimenType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSpecimenType.Location = new System.Drawing.Point(128, 44);
            this.txtSpecimenType.Name = "txtSpecimenType";
            this.txtSpecimenType.ReadOnly = true;
            this.txtSpecimenType.Size = new System.Drawing.Size(216, 20);
            this.txtSpecimenType.TabIndex = 4;
            // 
            // lvInappropriateRequests
            // 
            this.lvInappropriateRequests.AccessibleDescription = "In appropraite Requests";
            this.lvInappropriateRequests.AccessibleName = "In appropraite Requests";
            this.lvInappropriateRequests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvInappropriateRequests.CheckBoxes = true;
            this.lvInappropriateRequests.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colActive,
            this.colLabTestName,
            this.colIEN,
            this.colSpecimenType,
            this.colThresholdResult});
            this.lvInappropriateRequests.FullRowSelect = true;
            this.lvInappropriateRequests.HideSelection = false;
            this.lvInappropriateRequests.Location = new System.Drawing.Point(8, 120);
            this.lvInappropriateRequests.MultiSelect = false;
            this.lvInappropriateRequests.Name = "lvInappropriateRequests";
            this.lvInappropriateRequests.Size = new System.Drawing.Size(360, 112);
            this.lvInappropriateRequests.TabIndex = 9;
            this.lvInappropriateRequests.UseCompatibleStateImageBehavior = false;
            this.lvInappropriateRequests.View = System.Windows.Forms.View.Details;
            this.lvInappropriateRequests.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvInappropriateRequests_ColumnClick);
            this.lvInappropriateRequests.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvInappropriateRequests_ItemCheck);
            this.lvInappropriateRequests.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvInappropriateRequests_ItemChecked);
            this.lvInappropriateRequests.SelectedIndexChanged += new System.EventHandler(this.lvInappropriateRequests_SelectedIndexChanged);
            // 
            // colActive
            // 
            this.colActive.Text = "Active";
            this.colActive.Width = 45;
            // 
            // colLabTestName
            // 
            this.colLabTestName.Text = "Lab Test Name";
            this.colLabTestName.Width = 90;
            // 
            // colIEN
            // 
            this.colIEN.Text = "IEN";
            this.colIEN.Width = 30;
            // 
            // colSpecimenType
            // 
            this.colSpecimenType.Text = "Specimen Type";
            this.colSpecimenType.Width = 95;
            // 
            // colThresholdResult
            // 
            this.colThresholdResult.Text = "Threshold Result";
            this.colThresholdResult.Width = 95;
            // 
            // btnSelectLabTest
            // 
            this.btnSelectLabTest.AccessibleDescription = "find";
            this.btnSelectLabTest.AccessibleName = "find";
            this.btnSelectLabTest.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectLabTest.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSelectLabTest.Location = new System.Drawing.Point(344, 20);
            this.btnSelectLabTest.Name = "btnSelectLabTest";
            this.btnSelectLabTest.Size = new System.Drawing.Size(28, 20);
            this.btnSelectLabTest.TabIndex = 2;
            this.btnSelectLabTest.Text = "find";
            this.btnSelectLabTest.Click += new System.EventHandler(this.btnSelectLabTest_Click);
            // 
            // lblThresholdResult
            // 
            this.lblThresholdResult.Location = new System.Drawing.Point(8, 68);
            this.lblThresholdResult.Name = "lblThresholdResult";
            this.lblThresholdResult.Size = new System.Drawing.Size(128, 20);
            this.lblThresholdResult.TabIndex = 5;
            this.lblThresholdResult.Text = "Threshold Result*";
            this.lblThresholdResult.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblSpecimenType
            // 
            this.lblSpecimenType.Location = new System.Drawing.Point(8, 44);
            this.lblSpecimenType.Name = "lblSpecimenType";
            this.lblSpecimenType.Size = new System.Drawing.Size(128, 20);
            this.lblSpecimenType.TabIndex = 3;
            this.lblSpecimenType.Text = "Specimen Type";
            this.lblSpecimenType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblLabTestName
            // 
            this.lblLabTestName.Location = new System.Drawing.Point(8, 20);
            this.lblLabTestName.Name = "lblLabTestName";
            this.lblLabTestName.Size = new System.Drawing.Size(128, 20);
            this.lblLabTestName.TabIndex = 0;
            this.lblLabTestName.Text = "Laboratory Test Name";
            this.lblLabTestName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpConfigure
            // 
            this.grpConfigure.AccessibleDescription = "Selected Component Class Details";
            this.grpConfigure.AccessibleName = "Selected Component Class Details";
            this.grpConfigure.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpConfigure.Controls.Add(this.pnlRight);
            this.grpConfigure.Controls.Add(this.lblSpecimen);
            this.grpConfigure.Controls.Add(this.cbSpecimen);
            this.grpConfigure.Location = new System.Drawing.Point(216, 32);
            this.grpConfigure.Name = "grpConfigure";
            this.grpConfigure.Size = new System.Drawing.Size(392, 361);
            this.grpConfigure.TabIndex = 1;
            this.grpConfigure.TabStop = false;
            this.grpConfigure.Text = "Selected Component Class Details";
            // 
            // pnlRight
            // 
            this.pnlRight.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlRight.Controls.Add(this.pnlRequestIndicators);
            this.pnlRight.Controls.Add(this.pnlConfigWarning);
            this.pnlRight.Location = new System.Drawing.Point(8, 36);
            this.pnlRight.Name = "pnlRight";
            this.pnlRight.Size = new System.Drawing.Size(376, 316);
            this.pnlRight.TabIndex = 11;
            // 
            // pnlRequestIndicators
            // 
            this.pnlRequestIndicators.Controls.Add(this.grpRequestIndicators);
            this.pnlRequestIndicators.Controls.Add(this.lblMaxTransfusionTime);
            this.pnlRequestIndicators.Controls.Add(this.lblMinutes);
            this.pnlRequestIndicators.Controls.Add(this.updMaxTransfusionTime);
            this.pnlRequestIndicators.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlRequestIndicators.Location = new System.Drawing.Point(0, 36);
            this.pnlRequestIndicators.Name = "pnlRequestIndicators";
            this.pnlRequestIndicators.Size = new System.Drawing.Size(376, 280);
            this.pnlRequestIndicators.TabIndex = 1;
            // 
            // pnlConfigWarning
            // 
            this.pnlConfigWarning.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.pnlConfigWarning.Controls.Add(this.picConfigWarning);
            this.pnlConfigWarning.Controls.Add(this.lblConfigWarning);
            this.pnlConfigWarning.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlConfigWarning.Location = new System.Drawing.Point(0, 0);
            this.pnlConfigWarning.Name = "pnlConfigWarning";
            this.pnlConfigWarning.Size = new System.Drawing.Size(376, 36);
            this.pnlConfigWarning.TabIndex = 0;
            this.pnlConfigWarning.Visible = false;
            // 
            // picConfigWarning
            // 
            this.picConfigWarning.Image = ((System.Drawing.Image)(resources.GetObject("picConfigWarning.Image")));
            this.picConfigWarning.Location = new System.Drawing.Point(4, 4);
            this.picConfigWarning.Name = "picConfigWarning";
            this.picConfigWarning.Size = new System.Drawing.Size(16, 16);
            this.picConfigWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picConfigWarning.TabIndex = 17;
            this.picConfigWarning.TabStop = false;
            // 
            // lblConfigWarning
            // 
            this.lblConfigWarning.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblConfigWarning.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblConfigWarning.Location = new System.Drawing.Point(28, 4);
            this.lblConfigWarning.Name = "lblConfigWarning";
            this.lblConfigWarning.Size = new System.Drawing.Size(342, 32);
            this.lblConfigWarning.TabIndex = 0;
            this.lblConfigWarning.Text = "There are pending orders for the division. Settings cannot be configured until al" +
    "l orders are accepted or rejected.";
            // 
            // lblSpecimen
            // 
            this.lblSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblSpecimen.Location = new System.Drawing.Point(16, 16);
            this.lblSpecimen.Name = "lblSpecimen";
            this.lblSpecimen.Size = new System.Drawing.Size(248, 20);
            this.lblSpecimen.TabIndex = 0;
            this.lblSpecimen.Text = "&Require Current Specimen ABO/Rh Results?";
            this.lblSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // FrmConfigureComponents
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(612, 433);
            this.Controls.Add(this.grpConfigure);
            this.Controls.Add(this.grpComponentClass);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Component_Classes.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(620, 460);
            this.Name = "FrmConfigureComponents";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Configure Component Classes";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmConfigureComponents_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmConfigureComponents_Load);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpComponentClass, 0);
            this.Controls.SetChildIndex(this.grpConfigure, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.updMaxTransfusionTime)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpComponentClass.ResumeLayout(false);
            this.grpRequestIndicators.ResumeLayout(false);
            this.grpRequestIndicators.PerformLayout();
            this.grpConfigure.ResumeLayout(false);
            this.pnlRight.ResumeLayout(false);
            this.pnlRequestIndicators.ResumeLayout(false);
            this.pnlConfigWarning.ResumeLayout(false);
            this.pnlConfigWarning.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picConfigWarning)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/18/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to access function
		/// </summary>
		/// <returns></returns>
		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.EditConsultativeReports );
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Private method to set properties of user controls.
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC050.FrmConfigureComponents());
			
			btnOK.Text = "&OK";
			btnOK.EnabledButton = false;		
			
			btnUpdate.Text = "&Update";
			btnUpdate.EnabledButton = false;

			this.updMaxTransfusionTime.Maximum = Convert.ToDecimal(Common.MaximumTransfusionTime.Maximum);
			this.updMaxTransfusionTime.Value = Convert.ToDecimal(Common.MaximumTransfusionTime.Default);
			this.SetToolTips();
		    _removeItem = false;
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.lvComponentClass, Common.StrRes.Tooltips.UC050.ComponentClass());
			this.SetThisToolTip(this.lblSpecimen, Common.StrRes.Tooltips.UC050.SpecimemRequired());
			this.SetThisToolTip(this.cbSpecimen, Common.StrRes.Tooltips.UC050.SpecimemRequired());
			this.SetThisToolTip(this.updMaxTransfusionTime, Common.StrRes.Tooltips.UC050.MaxSpecimenTransfusionTime());
			//
			this.SetThisToolTip(this.txtLabTestName, Common.StrRes.Tooltips.UC050.LabTestName());
			this.SetThisToolTip(this.txtSpecimenType, Common.StrRes.Tooltips.UC033.SpecimenType());
			this.SetThisToolTip(this.txtThresholdResult, Common.StrRes.Tooltips.UC034.EnterThresholdResult());
			this.SetThisToolTip(this.btnSelectLabTest,Common.StrRes.Tooltips.UC050.LabTestSerach());
			this.SetThisToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearEntries());
			//
			this.SetThisToolTip(this.lvComponentClass, Common.StrRes.Tooltips.UC050.InappropriateTransfusionRequests());
			this.SetThisToolTip(this.cbShowInactive, Common.StrRes.Tooltips.Common.ShowInactive("inappropriate transfusion request indicators"));
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
			

		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		/// Loads the initial component class parameters into the listview.
		/// </summary>
		private void LoadComponentClasses()
		{
			lvComponentClass.Items.Clear();
			foreach(DataRow dr in _ComponentClasses.Rows)
			{
				//Set defaults - not yet defined in Division
				if (dr.RowState == DataRowState.Added)
				{
					dr[Common.VbecsTables.ComponentClassParameter.ComponentClassParameterGuid] = Guid.NewGuid();
					dr[Common.VbecsTables.ComponentClassParameter.OrderableIndicator] = true;
					dr[Common.VbecsTables.ComponentClassParameter.DivisionCode] = LogonUser.LogonUserDivisionCode;
					//BR_50.04
					dr[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime] = Convert.ToInt32(Common.MaximumTransfusionTime.Default);
					if ((Convert.ToInt32(dr[Common.VbecsTables.ComponentClassParameter.ComponentClassId]) == (int)Common.ComponentClass.RBC)
						|| (Convert.ToInt32(dr[Common.VbecsTables.ComponentClassParameter.ComponentClassId]) == (int)Common.ComponentClass.WB))
					{
						//BR_50.03
						dr[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator] = true;
					}
					else
					{
						dr[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator] = false;
					}
				}
				AddComponentClassToListView(dr);
			}
			//Now we have to sort, because the new items will be at the bottom otherwise...
			ColumnClickEventArgs e = new ColumnClickEventArgs(1);
			controls.ColumnClickSorter.ColumnClickHandler(this.lvComponentClass,e,false,controls.ColumnClickSorter.ColumnSortType.String);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Overloaded method to add details from a data row to the component class listview.
		/// </summary>
		/// <param name="dr"></param>
		private void AddComponentClassToListView(DataRow dr)
		{							
			ListViewItem lvi = new ListViewItem();
			lvi.Tag = dr;
			lvi.Text = dr[Common.VbecsTables.ComponentClass.ComponentClassName].ToString();
			lvi.SubItems.Add(dr[Common.VbecsTables.ComponentClass.SortColumn].ToString());
//			lvi.SubItems.Add(dr.IsNull(Common.VbecsTables.ComponentClassParameter.OrderableIndicator) ? "" : dr[Common.VbecsTables.ComponentClassParameter.OrderableIndicator].Equals(true) ? "Yes" : "No");
//			lvi.SubItems.Add(dr.IsNull(Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator) ? "" : dr[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator].Equals(true) ? "Yes" : "No");
//			lvi.SubItems.Add(dr.IsNull(Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime) ? "" : dr[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime].ToString() + " Mins");
			lvComponentClass.Items.Add(lvi);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Overloaded method to add details from a component class object to the component class listview.
		///</summary>
		private void AddComponentClassToListView()
		{
			DataRow dr = _ComponentClass.LoadDataRowFromThis(_ComponentClasses.NewRow());

			_ComponentClasses.Rows.Add(dr);

			AddComponentClassToListView(dr);

		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2002</CreationDate>
		///
		///<summary>
		/// Updates an existing blood component class in the listview and datatable.
		///</summary>
		private void UpdateComponentClassInListView()
		{
			foreach(ListViewItem lvi in lvComponentClass.Items)
			{
				if (lvi.SubItems[0].Text.Trim().ToUpper() == _ComponentClass.BloodComponentName.Trim().ToUpper())
				{
					DataRow dr = (DataRow)lvi.Tag;
					dr[Common.VbecsTables.ComponentClassParameter.OrderableIndicator] = _ComponentClass.IsOrderable;
					dr[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator] =_ComponentClass.IsSpecimenRequired; 
					dr[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime] = _ComponentClass.MaximumTransfusionTime;
					dr[Common.VbecsTables.ComponentClassParameter.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
//					lvi.Tag = dr;
//					lvi.SubItems[1].Text = dr[Common.VbecsTables.ComponentClassParameter.OrderableIndicator].Equals(true) ? "Yes" : "No";
//					lvi.SubItems[2].Text = dr[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator].Equals(true) ? "Yes" : "No";
//					lvi.SubItems[3].Text = _ComponentClass.MaximumTransfusionTime.ToString() + " Mins";

					return;
				}
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Gets all the lab test for the component classes.
		/// </summary>
		private void GetLabTests()
		{
			_LabTest = new BOL.LabTest();
			_LabTest.IsDirtyChanged += new System.EventHandler(CheckValidLabTest);
			_LabTest.Valid += new System.EventHandler(CheckValidLabTest);
			_LabTest.Invalid += new System.EventHandler(CheckValidLabTest);
			_LabTest.SetInitialBrokenRules(this.Name);

			_LabTests = _LabTest.GetLabTests();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Populates the form with the component class parameters from the blood component class object.
		/// </summary>
		private void PopulateForm()
		{
			this._isLoading = true;

			grpConfigure.Enabled = true;
			grpRequestIndicators.Enabled = true;
			//grpTransfusionTime.Enabled = true;
			//cbOrderable.Checked = (_ComponentClass.IsOrderable == true);

			if (_ComponentClass.BloodComponentClassId == 1 ||
				_ComponentClass.BloodComponentClassId == 6)
			{
				cbSpecimen.Checked = true;
			}
			else
			{
				cbSpecimen.Checked = (_ComponentClass.IsSpecimenRequired == true);
			}

			updMaxTransfusionTime.Value = _ComponentClass.MaximumTransfusionTime;

			this._isLoading = false;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Populates the form with the lab test parameters from the lab test object.
		/// </summary>
		private void PopulateLabTest()
		{
			txtLabTestName.Text = _LabTest.LabTestName;
			txtThresholdResult.Text = _LabTest.Threshold;
			if (_LabTest.SpecimenType == Common.SpecimenType.Unknown)
			{
				txtSpecimenType.Text = "";
			}
			else
			{
				txtSpecimenType.Text = _LabTest.SpecimenType.ToString();
			}
			CheckValidLabTest(this,EventArgs.Empty);
			txtThresholdResult.ReadOnly = false;
			errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
			errError.SetVbecsError(txtSpecimenType, ""); // **** 508 Compliance ***

			if (_LabTest.IsNew)
			{
				this.btnUpdate.Text = "&Add";
			}
			else
			{
				this.btnUpdate.Text = "&Update";
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		///  Loads the initial lab test parameters into the listview.
		/// </summary>
		private void LoadLabTests()
		{
			this._isLoading = true;

			lvInappropriateRequests.Items.Clear();

			DataRow[] dtRows = _LabTests.Select(Common.VbecsTables.ComponentClassParameter.ComponentClassId + " = " + _ComponentClass.BloodComponentClassId);

			foreach(DataRow dr in dtRows)
			{
				AddLabTestToListView(dr);
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvInappropriateRequests);

			this._isLoading = false;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2002</CreationDate>
		///
		/// <summary>
		///  Overloaded method to add details from a data row to the lab test listview.
		/// </summary>
		/// <param name="dr"></param>
		private void AddLabTestToListView(DataRow dr)
		{
			if ((Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode]) == Convert.ToChar(Common.RecordStatusCode.Inactive))&&
				(!this.cbShowInactive.Checked))
			{
				//Don't add if inactive and checkbox unchecked
				return;
			}
			else
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = dr;
				lvi.Checked = (Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode]) == Convert.ToChar(Common.RecordStatusCode.Active));
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString());
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString());
				//lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.WorkloadCode].ToString());
				//lvi.SubItems.Add(Common.Utility.GetSpecimenTypeFromString(dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString()).ToString());
				lvi.SubItems.Add(((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim()))).ToString());
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString());
				//
				if (lvi.Checked)
				{
					lvi.ForeColor = lvInappropriateRequests.ForeColor;
				}
				else
				{
					lvi.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
				}
				//
				lvInappropriateRequests.Items.Add(lvi);
				//
				//controls.VbecsFunction.SetColumnWidths(this.lvInappropriateRequests);
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Overloaded method to add details from a lab test object to the lab test listview.
		///</summary>
		private void AddLabTestToListView()
		{
			_LabTest.ComponentClassId = _ComponentClass.BloodComponentClassId;

			DataRow dr = _LabTest.LoadDataRowFromThis(_LabTests.NewRow());

			_LabTests.Rows.Add(dr);

			//AddLabTestToListView(dr);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2002</CreationDate>
		///
		///<summary>
		/// Updates an existing lab test parameter in the listview and datatable.
		///</summary>
		private void UpdateLabTestInListView()
		{
			DataRow[] dtRows = _LabTests.Select(Common.VbecsTables.ComponentClassParameter.ComponentClassId + " = " + _ComponentClass.BloodComponentClassId);

			//foreach(ListViewItem lvi in lvInappropriateRequests.Items)
			foreach(DataRow dr in dtRows)
			{
				if (dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString().ToUpper().Trim() == _LabTest.LabTestName.ToUpper().Trim())
				//if (lvi.SubItems[1].Text.Trim().ToUpper() == _LabTest.LabTestName.Trim().ToUpper())
				{
					//DataRow dr = (DataRow)lvi.Tag;
					dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode] = Convert.ToChar(_LabTest.SpecimenType);
					dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId] = _LabTest.LabTestId;
					dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult] = _LabTest.Threshold;
					dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);//_LabTest.RecordStatusCode);
					dr[Common.VbecsTables.SpecimenTestThreshold.LastUpdateUser] = ThisUser.UserNTLoginID;
					dr.Table.Columns[Common.VbecsTables.SpecimenTestThreshold.RowVersion].ReadOnly = false;
					
					if (_LabTest.RowVersion != null)
					{
						dr[Common.VbecsTables.SpecimenTestThreshold.RowVersion] = (byte[]) _LabTest.RowVersion;
					}
					//lvi.Tag = dr;
					foreach(ListViewItem lvi in lvInappropriateRequests.Items)
					{
						if ((DataRow)lvi.Tag == dr)
						{
							lvi.Checked = (_LabTest.RecordStatusCode == Common.RecordStatusCode.Active);
							//					lvi.SubItems[1].Text = _LabTest.LabTestName;
							//					lvi.SubItems[1].Text = _LabTest.LabWorkloadCode;
							lvi.SubItems[2].Text = _LabTest.LabTestId.ToString();
							lvi.SubItems[3].Text = _LabTest.SpecimenType.ToString();
							lvi.SubItems[4].Text = _LabTest.Threshold;
							//
							if (lvi.Checked)
							{
								lvi.ForeColor = lvInappropriateRequests.ForeColor;
							}
							else
							{
								lvi.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
							}
							//
							break;
						}
					}

					return;
				}
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvInappropriateRequests);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Checks for an existing lab test and load the object if it exists.
		///</summary>
		///<param name="labTestName">string</param>
		private void CheckExistingLabTests(string labTestName)
		{
			//foreach(ListViewItem lvi in lvInappropriateRequests.Items)
			foreach(DataRow dr in this._LabTests.Rows)
			{
				//if (lvi.SubItems[1].Text.ToUpper().Trim() == labTestName.ToUpper().Trim())
				if (dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString().ToUpper().Trim() == labTestName.ToUpper().Trim())
				{
					//_LabTest = new BOL.LabTest((DataRow)lvi.Tag);
					_LabTest = new BOL.LabTest(dr);
					_LabTest.IsDirtyChanged += new System.EventHandler(CheckValidLabTest);
					_LabTest.Valid += new System.EventHandler(CheckValidLabTest);
					_LabTest.Invalid += new System.EventHandler(CheckValidLabTest);
					_LabTest.IsNew = false;
					_LabTest.IsDirty = true;
					return;
				}
			}
			
			_LabTest.Clear();
			_LabTest.SetInitialBrokenRules(this.Name);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Clears the form of the blood component class being edited.
		///</summary>
		private void Clear()
		{
			_ComponentClass.Clear();
			
			grpConfigure.Enabled = false;
			grpRequestIndicators.Enabled = false;
			//grpTransfusionTime.Enabled = false;
			
			lvInappropriateRequests.Items.Clear();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Clears the form of the lab test parameter being added.
		///</summary>
		private void ClearLabTest()
		{
			_LabTest.Clear();
			PopulateLabTest();
			_LabTest.SetInitialBrokenRules(this.Name);
			
//			txtLabTestName.ReadOnly = false;
			txtThresholdResult.ReadOnly = true;
//			rdoBlood.Enabled = false;
//			rdoSerum.Enabled = false;
//			rdoPlasma.Enabled = false;
			
			lvInappropriateRequests.SelectedItems.Clear();
		}
		#endregion

		#region Events

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Form load event handler. Baselines data table as not having changed. Disables OK button.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void FrmConfigureComponents_Load(object sender, System.EventArgs e)
		{
//			this._isLoading = true;
//			//
//			_ComponentClass = new BOL.BloodComponentClass();
//			//_ComponentClass.IsDirtyChanged += new System.EventHandler(CheckValid);
//			//_ComponentClass.Valid += new System.EventHandler(CheckValid);
//			//_ComponentClass.Invalid += new System.EventHandler(CheckValid);
//			//
//			_ComponentClasses = _ComponentClass.GetComponentClasses();
//			_ComponentClasses.AcceptChanges();
//			LoadComponentClasses();
//			//
//			GetLabTests();
//			_LabTests.AcceptChanges();
//			//
//			_ComponentClasses.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);
//			_LabTests.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);
//			//
//			Clear();
//			//
//			SetComponentProperties();
//			//
//			this.btnOK.EnabledButton = false;
//			this.IsDirty = false;
//			//
//			this._isLoading = false;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		/// <summary>
		///  Listview click event handler. Loads selected row into UI controls for possible editing.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void lvComponentClass_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//
			if (this.lvComponentClass.SelectedItems.Count > 0)
			{
				_selectedComponentClass = (DataRow)this.lvComponentClass.SelectedItems[0].Tag;
				
				_ComponentClass = new BOL.BloodComponentClass(_selectedComponentClass);
				//_ComponentClass.IsDirtyChanged += new System.EventHandler(CheckValid);
				//_ComponentClass.Valid += new System.EventHandler(CheckValid);
				//_ComponentClass.Invalid += new System.EventHandler(CheckValid);
				_ComponentClass.IsNew = false;
				_ComponentClass.IsDirty = false;
				//_ComponentClass.IsDirtyChanged+=new EventHandler(_ComponentClass_IsDirtyChanged);

				PopulateForm();
				ClearLabTest();
				LoadLabTests();
				EnableSpecimenRequirement();
			}
			else
			{
				this._isLoading = true;
				_selectedComponentClass = this._ComponentClasses.NewRow();
				grpConfigure.Enabled = false;
				grpRequestIndicators.Enabled = false;
				this.cbSpecimen.Checked = false;
				this.updMaxTransfusionTime.Value = Convert.ToDecimal(Common.MaximumTransfusionTime.Default);
				ClearLabTest();
				this.lvInappropriateRequests.Items.Clear();
				this.pnlConfigWarning.Visible = false;
				this._isLoading = false;
			}
		}

		private void EnableSpecimenRequirement()
		{
			string message = "";
			//BR_50.03
			if (_ComponentClass.IncludesRedBloodCells)
			{
				message = Common.StrRes.InfoMsg.UC050.CannotConfigureRbcComponents(_ComponentClass.BloodComponentName).ResString;
			}
			else if (BOL.OrderedComponent.IsOrderedComponentPending((Common.ComponentClass)_ComponentClass.BloodComponentClassId))
			{
				//BR_55.02
				message = Common.StrRes.InfoMsg.UC050.CannotConfigureComponent(_ComponentClass.BloodComponentName).ResString;
			}
			this._isLoading = true;
			//
			if (message.Length>0)
			{
				this.cbSpecimen.Enabled = false;
				//
				this.lblConfigWarning.Text = message;
				this.pnlConfigWarning.Visible = true;
			}
			else
			{
				this.cbSpecimen.Enabled = true;
				this.pnlConfigWarning.Visible = false;
			}
			//
			this._isLoading = false;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		/// <summary>
		/// Check box check changed event handler. Updates the IsSpecimenRequired property.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void cbSpecimen_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				_ComponentClass.IsSpecimenRequired = cbSpecimen.Checked;
				_selectedComponentClass[Common.VbecsTables.ComponentClassParameter.SpecimenRequiredIndicator] =_ComponentClass.IsSpecimenRequired; 
				this.errError.SetVbecsError(this.cbSpecimen, ""); // **** 508 Compliance ***
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.cbSpecimen, err.Message); // **** 508 Compliance ***
				return;
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.cbSpecimen, err.Message); // **** 508 Compliance ***
				return;
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		/// <summary>
		/// Numeric up/down value changed event handler. Updates the MaximumTransfusionTime property.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updMaxTransfusionTime_ValueChanged(object sender, System.EventArgs e)
		{
			if (_ComponentClass != null && _selectedComponentClass != null)
			{
				try
				{
					_ComponentClass.MaximumTransfusionTime = (int) updMaxTransfusionTime.Value;
					_selectedComponentClass[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime] = _ComponentClass.MaximumTransfusionTime;
					this.errError.SetVbecsError(this.lblMinutes, string.Empty); // **** 508 Compliance ***
					this.lvComponentClass.Enabled = true;
				}
				catch(FormatException)
				{
					this.btnOK.EnabledButton = false;
					this.lvComponentClass.Enabled = false;
					return;
				}
				catch(BOL.BusinessObjectException err)
				{
					this.errError.SetVbecsError(this.lblMinutes, err.Message); // **** 508 Compliance ***
					return;
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.lblMinutes, err.Message); // **** 508 Compliance ***
					return;
				}
			}
		}

		private void updMaxTransfusionTime_Leave(object sender, System.EventArgs e)
		{
			try
			{
				_ComponentClass.MaximumTransfusionTime = (int) updMaxTransfusionTime.Value;
				_selectedComponentClass[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime] = _ComponentClass.MaximumTransfusionTime;
				this.errError.SetVbecsError(this.lblMinutes, string.Empty); // **** 508 Compliance ***
				this.lvComponentClass.Enabled = true;
			}
			catch(FormatException err)
			{
				//This is unacceptable - we can't let them leave!
				this.errError.SetVbecsError(this.lblMinutes, err.Message); // **** 508 Compliance ***
				this.btnOK.EnabledButton = false;
				this.lvComponentClass.Enabled = false;
				return;
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.lblMinutes, err.Message); // **** 508 Compliance ***
				return;
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.lblMinutes, err.Message); // **** 508 Compliance ***
				return;
			}

		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2002</CreationDate>
		///
		/// <summary>
		///   Threshold result leave event handler.  Sets an error message for invalid entry or the object's
		///   threshold result for valid entries.
		/// </summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void txtThresholdResult_Leave(object sender, System.EventArgs e)
		{
			if (txtThresholdResult.Text.Trim().Length > 0)
			{
				//Don't show error provider when user enters < or > character
				if ((txtThresholdResult.Text.Trim()!=">")&&(txtThresholdResult.Text.Trim()!="<"))
				{
					Regex numericThreshold = Common.RegularExpressions.Threshold();
					if (numericThreshold.IsMatch(txtThresholdResult.Text))
					{
						try
						{
							_LabTest.Threshold = txtThresholdResult.Text;
							errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
						}
						catch(BOL.BusinessObjectException)
						{
							_LabTest.Threshold = "";
							this.errError.SetVbecsError(this.txtThresholdResult, Common.StrRes.Tooltips.UC050.NumericThreshold().ResString); // **** 508 Compliance ***
							return;
						}
						catch (Exception err)
						{
							_LabTest.Threshold = "";
							this.errError.SetVbecsError(this.txtThresholdResult, err.Message); // **** 508 Compliance ***
						}
					}
					else
					{
						_LabTest.Threshold = "";
						this.errError.SetVbecsError(this.txtThresholdResult, Common.StrRes.Tooltips.UC050.NumericThreshold().ResString); // **** 508 Compliance ***
					}
				}
				else
				{
					errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
					_LabTest.Threshold = "";
				}
			}
			else
			{
				errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
				_LabTest.Threshold = "";
			}
		}

	
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		/// Broken rules and IsDirty change event handler. Enables update button if data is valid and has changed.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CheckValidLabTest(object sender, System.EventArgs e)
		{
			if (_LabTest.IsValid && _LabTest.IsDirty) 
			{
				btnUpdate.SetToolTip(Common.StrRes.Tooltips.UC050.ClickToSave().ResString);
				btnUpdate.EnabledButton = true;
			}
			else
			{
				btnUpdate.EnabledButton = false;
			}
			//
			if (_LabTest.IsDirty && !this._isLoading)
			{
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/26/2002</CreationDate>
		///
		/// <summary>
		///  Listview click event handler. Loads selected row into UI controls for possible editing.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void lvInappropriateRequests_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvInappropriateRequests.SelectedItems.Count > 0)
			{
				DataRow dr = (DataRow) lvInappropriateRequests.SelectedItems[0].Tag;
				//
				this._LabTest = new BOL.LabTest();
				this._LabTest.IsDirtyChanged += new System.EventHandler(CheckValidLabTest);
				this._LabTest.Valid += new System.EventHandler(CheckValidLabTest);
				this._LabTest.Invalid += new System.EventHandler(CheckValidLabTest);
				this._LabTest.SetInitialBrokenRules(this.Name);
				this._LabTest.ReportType = Common.ReportType.InappropriateTransfusionRequest;
				this._LabTest.SpecimenTestThresholdGuid = (Guid)dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTestThresholdGuid];
				this._LabTest.LabTestId = Convert.ToInt32(dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim());
				this._LabTest.LabTestName = dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString();
				this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
				this._LabTest.ThresholdType = Common.ThresholdType.Numeric;
				this._LabTest.Threshold = dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString();
				this._LabTest.RecordStatusCode = Common.Utility.GetRecordStatusCodeFromString(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode].ToString());
				if (dr.Table.Columns.Contains(Common.VbecsTables.SpecimenTestThreshold.RowVersion))
				{
					if (!dr.IsNull(Common.VbecsTables.SpecimenTestThreshold.RowVersion))
					{
						this._LabTest.RowVersion = (byte[]) dr[Common.VbecsTables.SpecimenTestThreshold.RowVersion];
					}
				}
				this._LabTest.IsNew = false;
				this._LabTest.IsDirty = false;
				//
				PopulateLabTest();
			}
			this.SpeakListViewWithCheckBox(lvInappropriateRequests);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/26/2002</CreationDate>
		///
		/// <summary>
		///  Listview column click event handler. Sorts the listview by the selected column.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">ColumnClickEventArgs</param>
		private void lvInappropriateRequests_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInappropriateRequests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.Integer);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInappropriateRequests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/26/2002</CreationDate>
		///
		/// <summary>
		/// List view check box change event handler. Updates data row with new record status value.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">ItemCheckEventArgs</param>
		private void lvInappropriateRequests_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			DataRow dr = (DataRow)lvInappropriateRequests.Items[e.Index].Tag;
			
			if (dr.Table.Columns.Contains(Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode))
			{
				if (e.NewValue == CheckState.Checked)
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active))
					{
						dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
						lvInappropriateRequests.Items[e.Index].ForeColor = lvInappropriateRequests.ForeColor;
						lvInappropriateRequests.Items[e.Index].Selected = true;
					}
				}
				else
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive))
					{
						dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
						lvInappropriateRequests.Items[e.Index].ForeColor = Color.FromKnownColor(KnownColor.GrayText);
						//
						if (!this.cbShowInactive.Checked)
						{
						    _removeItem = true;
						}
						else
						{
							lvInappropriateRequests.Items[e.Index].Selected = true;
						}
					}
				}	
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/2/2002</CreationDate>
		/// <summary>
		///  Update button click event handler. Adds or updates inappropriate request indicator to listview, then clears the
		///  inappropriate request indicator(lab test).
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			if (_LabTest.IsNew)
			{
				AddLabTestToListView();
			}
			else
			{
				UpdateLabTestInListView();
			}
			this.LoadLabTests();
			_ComponentClass.IsDirty = true;
			ClearLabTest();
//			txtLabTestName.Focus();
			btnSelectLabTest.Focus();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		/// <summary>
		/// Clear button click event hanlder. Calls ClearLabTest method.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearLabTest();	
			//txtLabTestName.Focus();
			btnSelectLabTest.Focus();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Data row change event handler. Enables OK button to allow saving of changed information.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void EnableOKButton(object sender, System.Data.DataRowChangeEventArgs e)
		{
			if (!this._isLoading)
			{
				this.IsDirty = true;
				try
				{
					if (this.updMaxTransfusionTime.Value > 0)
					{
						btnOK.EnabledButton = true;
						btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
					}
				}
				catch(FormatException)
				{
					btnOK.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/27/2002</CreationDate>
		///
		///<summary>
		/// Cancel button click event hanlder. Closes the form.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			Close();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		/// <summary>
		///  Update button mouse hover event handler. Displays broken rules as tool tip.
		/// </summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnUpdate_MouseHover(object sender, System.EventArgs e)
		{
			if (_LabTest.GetBrokenRulesMessage(this.Name).Length == 0) 
			{
				if (_LabTest.IsDirty == false)
				{
					btnUpdate.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToAddOrUpdate().ResString);
				}
				else
				{
					btnUpdate.SetToolTip(Common.StrRes.Tooltips.UC050.AddUpdateInappropriateRequestIndicator().ResString);
				}
			}
			else
			{
				System.Text.StringBuilder _str = new System.Text.StringBuilder();
				_str.Append(_LabTest.GetBrokenRulesMessage(this.Name));
				btnUpdate.SetToolTip(_str.ToString());
			}

			
		}


		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		/// <summary>
		///  Ok button mouse hover event handler. Displays broken rules as tool tip.
		/// </summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{

			if (btnOK.EnabledButton)
			{
				btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else
			{
				if (this.errError.GetError(lblMinutes).Length==0)
				{
					try
					{
						if (this.updMaxTransfusionTime.Value > 0)
							btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
					}
					catch(FormatException err)
					{
						btnOK.SetToolTip(err.Message.Replace("Value entered","Maximum transfusion time"));
					}
				}
				else
				{
					btnOK.SetToolTip("Maximum transfusion time is outside acceptable range ("+this.updMaxTransfusionTime.Minimum.ToString()+"-"+this.updMaxTransfusionTime.Maximum.ToString()+")");
				}
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/31/2002</CreationDate>
		///
		///<summary>
		/// Save button click event hanlder. Saves all the changed entries in lab test parameter table to the database.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("component class definition")) == DialogResult.Yes)
			{
				try
				{
					_ComponentClass.SaveComponentClasses(_ComponentClasses, _LabTests, Common.UpdateFunction.UC050FrmConfigureComponents);
					this.IsDirty = false;
				}
				catch (Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;			//CR2077
					GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
				this.Close();
			}					
		}

		private void btnSelectLabTest_Click(object sender, System.EventArgs e)
		{
			DlgSelectLabTest dlg = new DlgSelectLabTest(false,Common.ReportType.InappropriateTransfusionRequest);

            dlg.ShowDialogFromLockedParent(this, false);
			if (dlg.DialogResult != DialogResult.OK)
			{
				return;
			}
			//
			DataTable dt = dlg.SelectedLabTests;
			if (dt.Rows.Count==1)
			{
				//foreach(ListViewItem lvi in this.lvInappropriateRequests.Items)
				DataRow[] drComponentTests = this._LabTests.Select(Common.VbecsTables.SpecimenTestThreshold.ComponentClassId + " = " + this._ComponentClass.BloodComponentClassId);
				foreach(DataRow dr in drComponentTests) //this._LabTests.Rows)
				{
					//DataRow dr = (DataRow)lvi.Tag;
					if (dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim() == dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim())
					{
						bool found = false;
						foreach(ListViewItem lvi in this.lvInappropriateRequests.Items)
						{
							if ((DataRow)lvi.Tag == dr)
							{
								lvi.Selected = true;
								this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
								this.PopulateLabTest();
								found = true;
								break;
							}
						}
						if (!found)
						{
							//May need to just activate currently inactive row...
							dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode] = dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode];
							dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
							this.AddLabTestToListView(dr);
							this._LabTest.IsDirty = true;
						}
						return;
					}
				}
				//
				this._LabTest = new BOL.LabTest();
				this._LabTest.IsDirtyChanged += new System.EventHandler(CheckValidLabTest);
				this._LabTest.Valid += new System.EventHandler(CheckValidLabTest);
				this._LabTest.Invalid += new System.EventHandler(CheckValidLabTest);
				this._LabTest.SetInitialBrokenRules(this.Name);
				this._LabTest.ReportType = Common.ReportType.InappropriateTransfusionRequest;
				this._LabTest.IsNew = true;
				this._LabTest.SpecimenTestThresholdGuid = Guid.NewGuid();
				this._LabTest.LabTestId = Convert.ToInt32(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim());
				this._LabTest.LabTestName = dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString();
				this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
				this._LabTest.ThresholdType = Common.ThresholdType.Numeric;
				this._LabTest.RecordStatusCode = Common.RecordStatusCode.Active;
				this.PopulateLabTest();
			}
		}


		private void cbShowInactive_CheckedChanged(object sender, System.EventArgs e)
		{
			this.LoadLabTests();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmConfigureComponents_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnUpdate.EnabledButton == false)
			{
				this.btnUpdate_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnUpdate.GetToolTip();
			}
			else if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnOK.GetToolTip();
			}

			if (this.lblConfigWarning.Visible == true)
				textToSpeak += "\n" + this.lblSpecimen.Text + "\n" + this.lblConfigWarning.Text;

			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

        private void lvInappropriateRequests_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (!this._isLoading)
            {
                if (_removeItem)
                {
                    ((ListView) sender).Items.Remove(e.Item);
                    _removeItem = false;
                }
            }
        }

	}
}

